/*
 * Decompiled with CFR 0.152.
 */
package net.mm_mining.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.mm_mining.MmMiningMod;
import net.mm_mining.procedures.ProcHelpCrafterMinerPlusProcedure;
import net.mm_mining.procedures.ProcHelpCrusherControllerPlusProcedure;
import net.mm_mining.procedures.ProcHelpMinerControllerPlusProcedure;
import net.mm_mining.procedures.ProcHelpOreSmelterControllerMinusProcedure;
import net.mm_mining.procedures.ProcHelpOreSmelterControllerPlusProcedure;
import net.mm_mining.world.inventory.GuiHelpOreSmelterController2Menu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GuiHelpOreSmelterController2ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GuiHelpOreSmelterController2ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GuiHelpOreSmelterController2ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GuiHelpOreSmelterController2ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GuiHelpOreSmelterController2ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GuiHelpOreSmelterController2ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = GuiHelpOreSmelterController2Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProcHelpOreSmelterControllerMinusProcedure.execute((LevelAccessor)world, x, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ProcHelpOreSmelterControllerPlusProcedure.execute((LevelAccessor)world, x, z, (Entity)entity);
        }
        if (buttonID == 2) {
            ProcHelpCrafterMinerPlusProcedure.execute((LevelAccessor)world, x, z, (Entity)entity);
        }
        if (buttonID == 3) {
            ProcHelpMinerControllerPlusProcedure.execute((LevelAccessor)world, x, z, (Entity)entity);
        }
        if (buttonID == 4) {
            ProcHelpCrusherControllerPlusProcedure.execute((LevelAccessor)world, x, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MmMiningMod.addNetworkMessage(GuiHelpOreSmelterController2ButtonMessage.class, GuiHelpOreSmelterController2ButtonMessage::buffer, GuiHelpOreSmelterController2ButtonMessage::new, GuiHelpOreSmelterController2ButtonMessage::handler);
    }
}

